/*

    File: ftpp/cfgtool.cc

    Copyright (C) 2002  Dmitry Udalov
    Email: uddm@penza.net
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

 */


#include <stdio.h>
#include <stdlib.h>
#include "ftpproxy.h"

//read params from config file
int getparam(const char *paramname,char *paramvalue){
    //paramname - name of parametr - string
    //value of parametr - string too
    FILE *ofile=fopen(CONFNAME,"r");//open file
    if (ofile==NULL){
        strcpy(paramvalue,"");
        return FALSE;
    }
    fseek(ofile,0,SEEK_SET);
    char cBuf[STR_SIZE],cStr[STR_SIZE],*lpszPtr;
    int fRes=FALSE;
    //find %paramname% parametr
    while(feof(ofile)==0){
        fgets(cBuf,STR_SIZE,ofile);
        if(cBuf[strlen(cBuf)-1]=='\n')
            cBuf[strlen(cBuf)-1]='\0';
        if((strlen(cBuf)>0)&&(cBuf[0]=='#'))
            continue;
        if((lpszPtr=strstr(cBuf,paramname))!=NULL){
            lpszPtr=lpszPtr+strlen(paramname)+1;
            if(strlen(lpszPtr)<STR_SIZE)
                strcpy(cStr,lpszPtr);
            else{
                strncpy(cStr,lpszPtr,STR_SIZE-1);
                cStr[strlen(cStr)]='\0';
            }
            trim(cStr,cStr);
            strcpy(paramvalue,cStr);
            fRes=TRUE;
            break;
        }
    }
    //if not exists then return null string
    if(fRes==FALSE)
        strcpy(paramvalue,"");
    fclose(ofile);
    return fRes;
}

//get rights for ip addres szIP
//1 - host can connect to other servers
//0 - can't connect
int getiprights(const char* szIP){
//    return TRUE;
    //open file
    FILE *ofile=fopen(CONFNAME,"r");
    if (ofile==NULL){
        return 0;
    }
    fseek(ofile,0,SEEK_SET);
    char cBuf[STR_SIZE];
    //find string with szIP
    while(feof(ofile)==0){
        fgets(cBuf,STR_SIZE,ofile);
        if(strstr(cBuf,szIP)!=NULL){
            //if exists then return 1
            fclose(ofile);
            return 1;
        }
    }
    fclose(ofile);
    return 0;//0 if not exists
}


