/*

    File: ftpp/logtool.cc

    Copyright (C) 2002  Dmitry Udalov
    Email: uddm@penza.net
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
 */


#include "ftpproxy.h"


//save record to log file
void SaveLog(const char *lpszMsg,const char *lpszFileName){
        FILE *LogFile;
        LogFile=fopen(lpszFileName,"a");
        if(LogFile==NULL){
                return;
        }
        fprintf(LogFile,"%s\n",lpszMsg);
        fclose(LogFile);
}

//save record to ftpp.log
void log(struct ClientParam *Session,const char *lpszMsg){
    char cStr[BUF_SIZE];
    int fLogEnable;
    if(getparam("DEBUGLOGENABLE",cStr)==FALSE)
        fLogEnable=0;
    else
        fLogEnable=atoi(cStr);
    if(fLogEnable==FALSE)
        return;
    SaveLog(lpszMsg,szLogFileName);
}

//save formated record to ftpp.log
void logex(int iClientN,const char *fmt, ...){
    char cStr[BUF_SIZE];
    int fLogEnable;
    if(getparam("DEBUGLOGENABLE",cStr)==FALSE)
        fLogEnable=0;
    else
        fLogEnable=atoi(cStr);
    if(fLogEnable==FALSE)
        return;

    va_list args;
    time_t nowtime;
    static char cTime[STR_SIZE],cCntr[STR_SIZE+10],szLogStr[BUF_SIZE];
    va_start(args, fmt);
    nowtime = time(NULL);
    strftime(cTime, STR_SIZE, "%b %d %H:%M:%S", localtime(&nowtime));
    vsprintf(cStr, fmt, args);
    if((cStr[strlen(cStr)-2]=='\r') & (cStr[strlen(cStr)-2]=='\r'))
	cStr[strlen(cStr)-2]='\0';
    sprintf(szLogStr,"(%d) %s - %s",iClientN,cTime,cStr);
    SaveLog(szLogStr,szLogFileName);
}

//save record to acces log
void accesslog(struct ClientParam *Session,time_t tmtime,int iSize,int iResult,const char *lpszResource){
    char cStr[BUF_SIZE],cCAddr[STR_SIZE],cSAddr[STR_SIZE];
    time_t nowtime;
    time(&nowtime);
    strcpy(cCAddr,inet_ntoa(Session->ClientAddr.sin_addr));
    strcpy(cSAddr,inet_ntoa(Session->ServerAddr.sin_addr));
    sprintf(cStr,"%10d\t %10d\t %s\t %2d\t %10d\t %s\t %s",nowtime,iSize,cCAddr,iResult,tmtime,cSAddr,lpszResource);
    SaveLog(cStr,szAccessLogFileName);
}
